/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model;

import com.oracle.webservices.internal.api.databinding.DatabindingModeFeature;
import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.bind.api.TypeReference;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.databinding.Databinding;
import com.sun.xml.internal.ws.api.model.JavaMethod;
import com.sun.xml.internal.ws.api.model.ParameterBinding;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPart;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.db.DatabindingImpl;
import com.sun.xml.internal.ws.developer.JAXBContextFactory;
import com.sun.xml.internal.ws.developer.UsesJAXBContextFeature;
import com.sun.xml.internal.ws.model.CheckedExceptionImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.resources.ModelerMessages;
import com.sun.xml.internal.ws.spi.db.BindingContext;
import com.sun.xml.internal.ws.spi.db.BindingContextFactory;
import com.sun.xml.internal.ws.spi.db.BindingInfo;
import com.sun.xml.internal.ws.spi.db.TypeInfo;
import com.sun.xml.internal.ws.spi.db.XMLBridge;
import com.sun.xml.internal.ws.util.Pool;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebParam;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public abstract class AbstractSEIModelImpl
implements SEIModel {
    private List<Class> additionalClasses = new ArrayList<Class>();
    private Pool.Marshaller marshallers;
    protected JAXBRIContext jaxbContext;
    protected BindingContext bindingContext;
    private String wsdlLocation;
    private QName serviceName;
    private QName portName;
    private QName portTypeName;
    private Map<Method, JavaMethodImpl> methodToJM = new HashMap<Method, JavaMethodImpl>();
    private Map<QName, JavaMethodImpl> nameToJM = new HashMap<QName, JavaMethodImpl>();
    private Map<QName, JavaMethodImpl> wsdlOpToJM = new HashMap<QName, JavaMethodImpl>();
    private List<JavaMethodImpl> javaMethods = new ArrayList<JavaMethodImpl>();
    private final Map<TypeReference, Bridge> bridgeMap = new HashMap<TypeReference, Bridge>();
    private final Map<TypeInfo, XMLBridge> xmlBridgeMap = new HashMap<TypeInfo, XMLBridge>();
    protected final QName emptyBodyName = new QName("");
    private String targetNamespace = "";
    private List<String> knownNamespaceURIs = null;
    private WSDLPort port;
    private final WebServiceFeatureList features;
    private Databinding databinding;
    BindingID bindingId;
    protected Class contractClass;
    protected Class endpointClass;
    protected ClassLoader classLoader = null;
    protected WSBinding wsBinding;
    protected BindingInfo databindingInfo;
    protected String defaultSchemaNamespaceSuffix;
    private static final Logger LOGGER = Logger.getLogger(AbstractSEIModelImpl.class.getName());

    protected AbstractSEIModelImpl(WebServiceFeatureList webServiceFeatureList) {
        this.features = webServiceFeatureList;
        this.databindingInfo = new BindingInfo();
        this.databindingInfo.setSEIModel(this);
    }

    void postProcess() {
        if (this.jaxbContext != null) {
            return;
        }
        this.populateMaps();
        this.createJAXBContext();
    }

    public void freeze(WSDLPort wSDLPort) {
        this.port = wSDLPort;
        for (JavaMethodImpl javaMethodImpl : this.javaMethods) {
            javaMethodImpl.freeze(wSDLPort);
            this.putOp(javaMethodImpl.getOperationQName(), javaMethodImpl);
        }
        if (this.databinding != null) {
            ((DatabindingImpl)this.databinding).freeze(wSDLPort);
        }
    }

    protected abstract void populateMaps();

    @Override
    public Pool.Marshaller getMarshallerPool() {
        return this.marshallers;
    }

    @Override
    public JAXBContext getJAXBContext() {
        JAXBContext jAXBContext = this.bindingContext.getJAXBContext();
        if (jAXBContext != null) {
            return jAXBContext;
        }
        return this.jaxbContext;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public List<String> getKnownNamespaceURIs() {
        return this.knownNamespaceURIs;
    }

    public final Bridge getBridge(TypeReference typeReference) {
        Bridge bridge = this.bridgeMap.get(typeReference);
        assert (bridge != null);
        return bridge;
    }

    public final XMLBridge getXMLBridge(TypeInfo typeInfo) {
        XMLBridge xMLBridge = this.xmlBridgeMap.get(typeInfo);
        assert (xMLBridge != null);
        return xMLBridge;
    }

    private void createJAXBContext() {
        final List<TypeInfo> list = this.getAllTypeInfos();
        final ArrayList<Class> arrayList = new ArrayList<Class>(list.size() + this.additionalClasses.size());
        arrayList.addAll(this.additionalClasses);
        for (TypeInfo object : list) {
            arrayList.add((Class)object.type);
        }
        try {
            this.bindingContext = AccessController.doPrivileged(new PrivilegedExceptionAction<BindingContext>(){

                @Override
                public BindingContext run() throws Exception {
                    JAXBContextFactory jAXBContextFactory;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating JAXBContext with classes={0} and types={1}", new Object[]{arrayList, list});
                    }
                    UsesJAXBContextFeature usesJAXBContextFeature = AbstractSEIModelImpl.this.features.get(UsesJAXBContextFeature.class);
                    DatabindingModeFeature databindingModeFeature = AbstractSEIModelImpl.this.features.get(DatabindingModeFeature.class);
                    JAXBContextFactory jAXBContextFactory2 = jAXBContextFactory = usesJAXBContextFeature != null ? usesJAXBContextFeature.getFactory() : null;
                    if (jAXBContextFactory == null) {
                        jAXBContextFactory = JAXBContextFactory.DEFAULT;
                    }
                    AbstractSEIModelImpl.this.databindingInfo.properties().put(JAXBContextFactory.class.getName(), jAXBContextFactory);
                    if (databindingModeFeature != null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "DatabindingModeFeature in SEI specifies mode: {0}", databindingModeFeature.getMode());
                        }
                        AbstractSEIModelImpl.this.databindingInfo.setDatabindingMode(databindingModeFeature.getMode());
                    }
                    if (usesJAXBContextFeature != null) {
                        AbstractSEIModelImpl.this.databindingInfo.setDatabindingMode("glassfish.jaxb");
                    }
                    AbstractSEIModelImpl.this.databindingInfo.setClassLoader(AbstractSEIModelImpl.this.classLoader);
                    AbstractSEIModelImpl.this.databindingInfo.contentClasses().addAll(arrayList);
                    AbstractSEIModelImpl.this.databindingInfo.typeInfos().addAll(list);
                    AbstractSEIModelImpl.this.databindingInfo.properties().put("c14nSupport", Boolean.FALSE);
                    AbstractSEIModelImpl.this.databindingInfo.setDefaultNamespace(AbstractSEIModelImpl.this.getDefaultSchemaNamespace());
                    BindingContext bindingContext = BindingContextFactory.create(AbstractSEIModelImpl.this.databindingInfo);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Created binding context: " + bindingContext.getClass().getName());
                    }
                    return bindingContext;
                }
            });
            this.createBondMap(list);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new WebServiceException(ModelerMessages.UNABLE_TO_CREATE_JAXB_CONTEXT(), privilegedActionException);
        }
        this.knownNamespaceURIs = new ArrayList<String>();
        for (String string : this.bindingContext.getKnownNamespaceURIs()) {
            if (string.length() <= 0 || string.equals("http://www.w3.org/2001/XMLSchema") || string.equals("http://www.w3.org/XML/1998/namespace")) continue;
            this.knownNamespaceURIs.add(string);
        }
        this.marshallers = new Pool.Marshaller(this.jaxbContext);
    }

    private List<TypeInfo> getAllTypeInfos() {
        ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
        Collection<JavaMethodImpl> collection = this.methodToJM.values();
        for (JavaMethodImpl javaMethodImpl : collection) {
            javaMethodImpl.fillTypes(arrayList);
        }
        return arrayList;
    }

    private void createBridgeMap(List<TypeReference> list) {
        for (TypeReference typeReference : list) {
            Bridge bridge = this.jaxbContext.createBridge(typeReference);
            this.bridgeMap.put(typeReference, bridge);
        }
    }

    private void createBondMap(List<TypeInfo> list) {
        for (TypeInfo typeInfo : list) {
            XMLBridge xMLBridge = this.bindingContext.createBridge(typeInfo);
            this.xmlBridgeMap.put(typeInfo, xMLBridge);
        }
    }

    public boolean isKnownFault(QName qName, Method method) {
        JavaMethodImpl javaMethodImpl = this.getJavaMethod(method);
        for (CheckedExceptionImpl checkedExceptionImpl : javaMethodImpl.getCheckedExceptions()) {
            if (!checkedExceptionImpl.getDetailType().tagName.equals(qName)) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckedException(Method method, Class clazz) {
        JavaMethodImpl javaMethodImpl = this.getJavaMethod(method);
        for (CheckedExceptionImpl checkedExceptionImpl : javaMethodImpl.getCheckedExceptions()) {
            if (!checkedExceptionImpl.getExceptionClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JavaMethodImpl getJavaMethod(Method method) {
        return this.methodToJM.get(method);
    }

    @Override
    public JavaMethodImpl getJavaMethod(QName qName) {
        return this.nameToJM.get(qName);
    }

    @Override
    public JavaMethod getJavaMethodForWsdlOperation(QName qName) {
        return this.wsdlOpToJM.get(qName);
    }

    public QName getQNameForJM(JavaMethodImpl javaMethodImpl) {
        for (QName qName : this.nameToJM.keySet()) {
            JavaMethodImpl javaMethodImpl2 = this.nameToJM.get(qName);
            if (!javaMethodImpl2.getOperationName().equals(javaMethodImpl.getOperationName())) continue;
            return qName;
        }
        return null;
    }

    public final Collection<JavaMethodImpl> getJavaMethods() {
        return Collections.unmodifiableList(this.javaMethods);
    }

    void addJavaMethod(JavaMethodImpl javaMethodImpl) {
        if (javaMethodImpl != null) {
            this.javaMethods.add(javaMethodImpl);
        }
    }

    private List<ParameterImpl> applyRpcLitParamBinding(JavaMethodImpl javaMethodImpl, WrapperParameter wrapperParameter, WSDLBoundPortType wSDLBoundPortType, WebParam.Mode mode) {
        QName qName = new QName(wSDLBoundPortType.getPortTypeName().getNamespaceURI(), javaMethodImpl.getOperationName());
        WSDLBoundOperation wSDLBoundOperation = wSDLBoundPortType.get(qName);
        HashMap<Integer, ParameterImpl> hashMap = new HashMap<Integer, ParameterImpl>();
        ArrayList<ParameterImpl> arrayList = new ArrayList<ParameterImpl>();
        ArrayList<ParameterImpl> arrayList2 = new ArrayList<ParameterImpl>();
        for (ParameterImpl parameterImpl : wrapperParameter.wrapperChildren) {
            ParameterBinding parameterBinding;
            String string = parameterImpl.getPartName();
            if (string == null || (parameterBinding = wSDLBoundPortType.getBinding(qName, string, mode)) == null) continue;
            if (mode == WebParam.Mode.IN) {
                parameterImpl.setInBinding(parameterBinding);
            } else if (mode == WebParam.Mode.OUT || mode == WebParam.Mode.INOUT) {
                parameterImpl.setOutBinding(parameterBinding);
            }
            if (parameterBinding.isUnbound()) {
                arrayList.add(parameterImpl);
                continue;
            }
            if (parameterBinding.isAttachment()) {
                arrayList2.add(parameterImpl);
                continue;
            }
            if (!parameterBinding.isBody()) continue;
            if (wSDLBoundOperation != null) {
                WSDLPart wSDLPart = wSDLBoundOperation.getPart(parameterImpl.getPartName(), mode);
                if (wSDLPart != null) {
                    hashMap.put(wSDLPart.getIndex(), parameterImpl);
                    continue;
                }
                hashMap.put(hashMap.size(), parameterImpl);
                continue;
            }
            hashMap.put(hashMap.size(), parameterImpl);
        }
        wrapperParameter.clear();
        for (int i = 0; i < hashMap.size(); ++i) {
            ParameterImpl parameterImpl;
            parameterImpl = (ParameterImpl)hashMap.get(i);
            wrapperParameter.addWrapperChild(parameterImpl);
        }
        for (ParameterImpl parameterImpl : arrayList) {
            wrapperParameter.addWrapperChild(parameterImpl);
        }
        return arrayList2;
    }

    void put(QName qName, JavaMethodImpl javaMethodImpl) {
        this.nameToJM.put(qName, javaMethodImpl);
    }

    void put(Method method, JavaMethodImpl javaMethodImpl) {
        this.methodToJM.put(method, javaMethodImpl);
    }

    void putOp(QName qName, JavaMethodImpl javaMethodImpl) {
        this.wsdlOpToJM.put(qName, javaMethodImpl);
    }

    @Override
    public String getWSDLLocation() {
        return this.wsdlLocation;
    }

    void setWSDLLocation(String string) {
        this.wsdlLocation = string;
    }

    @Override
    public QName getServiceQName() {
        return this.serviceName;
    }

    @Override
    public WSDLPort getPort() {
        return this.port;
    }

    @Override
    public QName getPortName() {
        return this.portName;
    }

    @Override
    public QName getPortTypeName() {
        return this.portTypeName;
    }

    void setServiceQName(QName qName) {
        this.serviceName = qName;
    }

    void setPortName(QName qName) {
        this.portName = qName;
    }

    void setPortTypeName(QName qName) {
        this.portTypeName = qName;
    }

    void setTargetNamespace(String string) {
        this.targetNamespace = string;
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    String getDefaultSchemaNamespace() {
        String string = this.getTargetNamespace();
        if (this.defaultSchemaNamespaceSuffix == null) {
            return string;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string + this.defaultSchemaNamespaceSuffix;
    }

    @Override
    @NotNull
    public QName getBoundPortTypeName() {
        assert (this.portName != null);
        return new QName(this.portName.getNamespaceURI(), this.portName.getLocalPart() + "Binding");
    }

    public void addAdditionalClasses(Class ... classArray) {
        for (Class clazz : classArray) {
            this.additionalClasses.add(clazz);
        }
    }

    public Databinding getDatabinding() {
        return this.databinding;
    }

    public void setDatabinding(Databinding databinding) {
        this.databinding = databinding;
    }

    public WSBinding getWSBinding() {
        return this.wsBinding;
    }

    public Class getContractClass() {
        return this.contractClass;
    }

    public Class getEndpointClass() {
        return this.endpointClass;
    }
}

