/*
 * Decompiled with CFR 0.152.
 */
package jdk.xml.internal;

import jdk.xml.internal.SecuritySupport;

public class JdkXmlFeatures {
    public static final String ORACLE_JAXP_PROPERTY_PREFIX = "http://www.oracle.com/xml/jaxp/properties/";
    public static final String XML_FEATURE_MANAGER = "http://www.oracle.com/xml/jaxp/properties/XmlFeatureManager";
    public static final String ORACLE_FEATURE_SERVICE_MECHANISM = "http://www.oracle.com/feature/use-service-mechanism";
    public static final String ORACLE_ENABLE_EXTENSION_FUNCTION = "http://www.oracle.com/xml/jaxp/properties/enableExtensionFunctions";
    public static final String SP_ENABLE_EXTENSION_FUNCTION = "javax.xml.enableExtensionFunctions";
    public static final String SP_ENABLE_EXTENSION_FUNCTION_SPEC = "jdk.xml.enableExtensionFunctions";
    private final boolean[] featureValues = new boolean[XmlFeature.values().length];
    private final State[] states = new State[XmlFeature.values().length];
    boolean secureProcessing;

    public JdkXmlFeatures(boolean bl) {
        this.secureProcessing = bl;
        for (XmlFeature xmlFeature : XmlFeature.values()) {
            if (bl && xmlFeature.enforced()) {
                this.featureValues[xmlFeature.ordinal()] = xmlFeature.enforcedValue();
                this.states[xmlFeature.ordinal()] = State.FSP;
                continue;
            }
            this.featureValues[xmlFeature.ordinal()] = xmlFeature.defaultValue();
            this.states[xmlFeature.ordinal()] = State.DEFAULT;
        }
        this.readSystemProperties();
    }

    public void update() {
        this.readSystemProperties();
    }

    public boolean setFeature(String string, State state, Object object) {
        int n = this.getIndex(string);
        if (n > -1) {
            this.setFeature(n, state, object);
            return true;
        }
        return false;
    }

    public void setFeature(XmlFeature xmlFeature, State state, boolean bl) {
        this.setFeature(xmlFeature.ordinal(), state, bl);
    }

    public boolean getFeature(XmlFeature xmlFeature) {
        return this.featureValues[xmlFeature.ordinal()];
    }

    public boolean getFeature(int n) {
        return this.featureValues[n];
    }

    public void setFeature(int n, State state, Object object) {
        boolean bl = Boolean.class.isAssignableFrom(object.getClass()) ? (Boolean)object : Boolean.parseBoolean((String)object);
        this.setFeature(n, state, bl);
    }

    public void setFeature(int n, State state, boolean bl) {
        if (state.compareTo(this.states[n]) >= 0) {
            this.featureValues[n] = bl;
            this.states[n] = state;
        }
    }

    public int getIndex(String string) {
        for (XmlFeature xmlFeature : XmlFeature.values()) {
            if (!xmlFeature.equalsPropertyName(string)) continue;
            return xmlFeature.ordinal();
        }
        return -1;
    }

    private void readSystemProperties() {
        for (XmlFeature xmlFeature : XmlFeature.values()) {
            String string;
            if (this.getSystemProperty(xmlFeature, xmlFeature.systemProperty()) || (string = xmlFeature.systemPropertyOld()) == null) continue;
            this.getSystemProperty(xmlFeature, string);
        }
    }

    private boolean getSystemProperty(XmlFeature xmlFeature, String string) {
        try {
            String string2 = SecuritySupport.getSystemProperty(string);
            if (string2 != null && !string2.equals("")) {
                this.setFeature(xmlFeature, State.SYSTEMPROPERTY, Boolean.parseBoolean(string2));
                return true;
            }
            string2 = SecuritySupport.readJAXPProperty(string);
            if (string2 != null && !string2.equals("")) {
                this.setFeature(xmlFeature, State.JAXPDOTPROPERTIES, Boolean.parseBoolean(string2));
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Invalid setting for system property: " + xmlFeature.systemProperty());
        }
        return false;
    }

    public static enum State {
        DEFAULT("default"),
        FSP("FEATURE_SECURE_PROCESSING"),
        JAXPDOTPROPERTIES("jaxp.properties"),
        SYSTEMPROPERTY("system property"),
        APIPROPERTY("property");

        final String literal;

        private State(String string2) {
            this.literal = string2;
        }

        String literal() {
            return this.literal;
        }
    }

    public static enum XmlFeature {
        ENABLE_EXTENSION_FUNCTION("http://www.oracle.com/xml/jaxp/properties/enableExtensionFunctions", "jdk.xml.enableExtensionFunctions", "http://www.oracle.com/xml/jaxp/properties/enableExtensionFunctions", "javax.xml.enableExtensionFunctions", true, false, true, true),
        JDK_OVERRIDE_PARSER("jdk.xml.overrideDefaultParser", "jdk.xml.overrideDefaultParser", "http://www.oracle.com/feature/use-service-mechanism", "http://www.oracle.com/feature/use-service-mechanism", false, false, true, false);

        private final String name;
        private final String nameSP;
        private final String nameOld;
        private final String nameOldSP;
        private final boolean valueDefault;
        private final boolean valueEnforced;
        private final boolean hasSystem;
        private final boolean enforced;

        private XmlFeature(String string2, String string3, String string4, String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.name = string2;
            this.nameSP = string3;
            this.nameOld = string4;
            this.nameOldSP = string5;
            this.valueDefault = bl;
            this.valueEnforced = bl2;
            this.hasSystem = bl3;
            this.enforced = bl4;
        }

        boolean equalsPropertyName(String string) {
            return this.name.equals(string) || this.nameOld != null && this.nameOld.equals(string);
        }

        public String apiProperty() {
            return this.name;
        }

        String systemProperty() {
            return this.nameSP;
        }

        String systemPropertyOld() {
            return this.nameOldSP;
        }

        public boolean defaultValue() {
            return this.valueDefault;
        }

        public boolean enforcedValue() {
            return this.valueEnforced;
        }

        boolean hasSystemProperty() {
            return this.hasSystem;
        }

        boolean enforced() {
            return this.enforced;
        }
    }
}

